/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.rendimiento.valores.ModeloValoresRetenido;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.ComprobanteRendimiento;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.compras.ComponenteFiscalidad;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wb.swt.SWTResourceManager;

public class DialogoComprobanteRendimiento
extends DialogoBase
implements VistaModelo<ComprobanteRendimiento>,
VistaValoresPropios {
    private boolean editando;
    private ComprobanteRendimiento comprobanteActual = new ComprobanteRendimiento();
    private List<ComprobanteRendimiento> comprobantesExistentes;
    private ComprobanteRendimiento modeloDatos;
    private ModeloValoresRetenido modeloValores;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private final Periodo periodo;
    private Text txtNumAutorizacion;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtSecuencial;
    private Label lblInfoPago;
    private Label lblPago;
    private Combo cmbPago;
    private ComboViewer cvTipoPago;
    private Label lblAplicaConvenio;
    private Composite compositeAplicaConvenioDobleTributacion;
    private Button btnSiAplicaConvenio;
    private Button btnNoAplicaConvenio;
    private Label lblPagoNormaLegal;
    private Composite compositePagoSujetoARetencion;
    private Button btnSiPagoNormaLegal;
    private Button btnNoPagoNormaLegal;
    private Label lblPagoSujetoRetencion;
    private Composite compositePagoRegimenFiscalPreferente;
    private Button btnSiPagoRegimenFiscal;
    private Button btnNoPagoRegimenFiscal;
    private Composite composite_4;
    private Composite composite_5;
    private ComponenteFiscalidad compFiscalidad;

    public DialogoComprobanteRendimiento(IWorkbenchPartSite site, List<ComprobanteRendimiento> comprobantesExistentes, boolean editando, Periodo periodo) {
        super(site);
        this.comprobantesExistentes = comprobantesExistentes;
        this.editando = editando;
        this.periodo = periodo;
    }

    public void setModeloDatos(ComprobanteRendimiento modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.compFiscalidad = new ComponenteFiscalidad(modeloDatos.getPagoLocalExterior(), this.periodo);
        if (this.editando) {
            this.comprobanteActual.setPropietario(modeloDatos.getPropietario());
            this.comprobanteActual.setEstablecimiento(modeloDatos.getEstablecimiento());
            this.comprobanteActual.setPuntoEmision(modeloDatos.getPuntoEmision());
            this.comprobanteActual.setSecuencial(modeloDatos.getSecuencial());
            this.comprobanteActual.setNumAutorizacion(modeloDatos.getNumAutorizacion());
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresRetenido();
        this.modeloValores.inicializar();
    }

    public void procesarModeloDatos() {
        boolean esPagoANoResidente = false;
        String codigoPago = this.modeloDatos.getPagoLocalExterior().getFiscalidad().getTipoPago();
        ElementoNombreValor tipoPago = this.modeloValores.obtenerTipoPago(codigoPago);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoPago, (Object)tipoPago);
        this.compFiscalidad.inicializarViews();
        if (tipoPago != null) {
            esPagoANoResidente = "02".equals(tipoPago.getValor());
            this.habilitarInformacionDelPagoANoResidenteDesdeMarzo2015((ElementoNombreValor<String>)tipoPago);
            this.compFiscalidad.determinarTipoRegimen();
        }
        this.compFiscalidad.habilitarConvenioYRetencionParaPagoExteriorModoEdicion(esPagoANoResidente);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoComprobanteRendimiento.this.modeloDatos.equals((Object)DialogoComprobanteRendimiento.this.comprobanteActual) && DialogoComprobanteRendimiento.this.comprobantesExistentes.contains(DialogoComprobanteRendimiento.this.modeloDatos)) {
                    resultado.fallarValidacion("El Comprobante de Retenci\u00f3n ya se encuentra registrado");
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getPagoLocalExterior().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getPagoLocalExterior().getFiscalidad().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getPagoLocalExterior().removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n");
        this.setTitle("Informaci\u00f3n del Comprobante de Retenci\u00f3n");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        GridData gd_composite = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_composite.widthHint = 342;
        composite.setLayoutData((Object)gd_composite);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        Label lblEstablecimiento = new Label(composite, 0);
        lblEstablecimiento.setText("Establecimiento");
        Label lblPuntoDeEmisin = new Label(composite, 0);
        lblPuntoDeEmisin.setText("Punto de Emisi\u00f3n");
        Label lblSecuencial = new Label(composite, 0);
        lblSecuencial.setText("Secuencial");
        this.txtEstablecimiento = new Text(composite, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteRendimiento.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        this.txtEstablecimiento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPuntoEmision = new Text(composite, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteRendimiento.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        this.txtPuntoEmision.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSecuencial = new Text(composite, 2048);
        this.txtSecuencial.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteRendimiento.this.txtSecuencial.selectAll();
            }
        });
        this.txtSecuencial.setTextLimit(9);
        this.txtSecuencial.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.composite_4 = new Composite(container, 0);
        GridData gd_composite_4 = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_composite_4.heightHint = 36;
        gd_composite_4.widthHint = 342;
        this.composite_4.setLayoutData((Object)gd_composite_4);
        Label lblNAutorizacin = new Label(this.composite_4, 0);
        lblNAutorizacin.setBounds(0, 10, 84, 15);
        lblNAutorizacin.setText("N\u00b0 Autorizaci\u00f3n");
        this.txtNumAutorizacion = new Text(this.composite_4, 2048);
        this.txtNumAutorizacion.setBounds(100, 7, 230, 28);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoComprobanteRendimiento.this.txtNumAutorizacion.selectAll();
            }
        });
        this.txtNumAutorizacion.setTextLimit(49);
        this.composite_5 = new Composite(container, 0);
        GridData gd_composite_5 = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_composite_5.heightHint = 36;
        gd_composite_5.widthHint = 342;
        this.composite_5.setLayoutData((Object)gd_composite_5);
        Label lblFechaDeEmisin = new Label(this.composite_5, 0);
        lblFechaDeEmisin.setBounds(0, 10, 105, 15);
        lblFechaDeEmisin.setText("Fecha de Emisi\u00f3n");
        final CDateTime dtFechaEmision = new CDateTime(this.composite_5, 32771);
        dtFechaEmision.setBounds(100, 7, 230, 21);
        dtFechaEmision.setNullText("seleccione la fecha");
        dtFechaEmision.setPattern("dd/MM/yyyy");
        dtFechaEmision.setSelection(this.modeloDatos.getFechaEmision());
        dtFechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialogoComprobanteRendimiento.this.modeloDatos.setFechaEmision(dtFechaEmision.getSelection());
            }
        });
        this.lblInfoPago = new Label(container, 0);
        this.lblInfoPago.setText("Informaci\u00f3n del Pago");
        this.lblInfoPago.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        new Label(container, 0);
        this.lblPago = new Label(container, 0);
        this.lblPago.setText("Pago Residente o no Residente");
        this.cvTipoPago = new ComboViewer(container, 8);
        this.tipoPagoSelectionChanged();
        this.cmbPago = this.cvTipoPago.getCombo();
        GridData gd_cmbPago = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_cmbPago.widthHint = 190;
        this.cmbPago.setLayoutData((Object)gd_cmbPago);
        this.compFiscalidad.crearComponenteFiscalidad(container, false);
        this.lblAplicaConvenio = new Label(container, 0);
        this.lblAplicaConvenio.setText("\u00bfAplica convenio de doble tributaci\u00f3n?");
        this.compositeAplicaConvenioDobleTributacion = new Composite(container, 0);
        this.compositeAplicaConvenioDobleTributacion.setLayout((Layout)new GridLayout(2, false));
        this.btnSiAplicaConvenio = new Button(this.compositeAplicaConvenioDobleTributacion, 16);
        this.btnSiAplicaConvenio.setEnabled(false);
        GridData gd_btnSiAplicaConvenio = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSiAplicaConvenio.widthHint = 50;
        this.btnSiAplicaConvenio.setLayoutData((Object)gd_btnSiAplicaConvenio);
        this.btnSiAplicaConvenio.setText("SI");
        this.btnNoAplicaConvenio = new Button(this.compositeAplicaConvenioDobleTributacion, 16);
        this.btnNoAplicaConvenio.setEnabled(false);
        GridData gd_btnNoAplicaConvenio = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnNoAplicaConvenio.widthHint = 50;
        this.btnNoAplicaConvenio.setLayoutData((Object)gd_btnNoAplicaConvenio);
        this.btnNoAplicaConvenio.setText("NO");
        this.lblPagoNormaLegal = new Label(container, 0);
        this.lblPagoNormaLegal.setText("\u00bfPago sujeto a retenci\u00f3n en aplicaci\u00f3n de la norma legal?");
        this.compositePagoSujetoARetencion = new Composite(container, 0);
        this.compositePagoSujetoARetencion.setLayout((Layout)new GridLayout(2, false));
        this.btnSiPagoNormaLegal = new Button(this.compositePagoSujetoARetencion, 16);
        this.btnSiPagoNormaLegal.setEnabled(false);
        GridData gd_btnSiPagoNormaLegal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSiPagoNormaLegal.widthHint = 50;
        this.btnSiPagoNormaLegal.setLayoutData((Object)gd_btnSiPagoNormaLegal);
        this.btnSiPagoNormaLegal.setText("SI");
        this.btnNoPagoNormaLegal = new Button(this.compositePagoSujetoARetencion, 16);
        this.btnNoPagoNormaLegal.setEnabled(false);
        GridData gd_btnNoNormaLegal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnNoNormaLegal.widthHint = 50;
        this.btnNoPagoNormaLegal.setLayoutData((Object)gd_btnNoNormaLegal);
        this.btnNoPagoNormaLegal.setText("NO");
        this.lblPagoSujetoRetencion = new Label(container, 0);
        GridData gd_lblPagoSujetoRetencion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblPagoSujetoRetencion.widthHint = 370;
        this.lblPagoSujetoRetencion.setLayoutData((Object)gd_lblPagoSujetoRetencion);
        this.lblPagoSujetoRetencion.setText("\u00bfEl pago es un r\u00e9gimen fiscal preferente o de menor imposici\u00f3n?");
        this.compositePagoRegimenFiscalPreferente = new Composite(container, 0);
        this.compositePagoRegimenFiscalPreferente.setLayout((Layout)new GridLayout(2, false));
        this.btnSiPagoRegimenFiscal = new Button(this.compositePagoRegimenFiscalPreferente, 16);
        this.btnSiPagoRegimenFiscal.setEnabled(false);
        GridData gd_btnSiPagoRegimenFiscal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnSiPagoRegimenFiscal.widthHint = 50;
        this.btnSiPagoRegimenFiscal.setLayoutData((Object)gd_btnSiPagoRegimenFiscal);
        this.btnSiPagoRegimenFiscal.setText("SI");
        this.btnNoPagoRegimenFiscal = new Button(this.compositePagoRegimenFiscalPreferente, 16);
        this.btnNoPagoRegimenFiscal.setEnabled(false);
        GridData gd_btnNoPagoRegimenFiscal = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnNoPagoRegimenFiscal.widthHint = 50;
        this.btnNoPagoRegimenFiscal.setLayoutData((Object)gd_btnNoPagoRegimenFiscal);
        this.btnNoPagoRegimenFiscal.setText("NO");
        this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    private void tipoPagoSelectionChanged() {
        this.cvTipoPago.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoPago = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoPago != null) {
                    boolean esPagoANoResidente = "02".equals(tipoPago.getValor());
                    DialogoComprobanteRendimiento.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setTipoPago((String)tipoPago.getValor());
                    DialogoComprobanteRendimiento.this.modeloDatos.getPagoLocalExterior().getFiscalidad().setDescripcionTipoPago(tipoPago.getNombre());
                    DialogoComprobanteRendimiento.this.habilitarInformacionDelPagoANoResidenteDesdeMarzo2015((ElementoNombreValor<String>)tipoPago);
                    DialogoComprobanteRendimiento.this.compFiscalidad.habilitarPagoExteriorLuegoDeLaSeleccionDelTipoDePago(esPagoANoResidente);
                }
            }
        });
    }

    private void habilitarInformacionDelPagoANoResidenteDesdeMarzo2015(ElementoNombreValor<String> tipoPago) {
        if (tipoPago != null) {
            boolean esPagoANoResidenteYPeriodoDesdeMarzo2015 = "02".equals(tipoPago.getValor()) && this.periodo.isPeriodoDeAnexoDesdeMarzo2015();
            this.btnSiAplicaConvenio.setEnabled(esPagoANoResidenteYPeriodoDesdeMarzo2015);
            this.btnNoAplicaConvenio.setEnabled(esPagoANoResidenteYPeriodoDesdeMarzo2015);
            this.btnSiPagoNormaLegal.setEnabled(esPagoANoResidenteYPeriodoDesdeMarzo2015 && !this.modeloDatos.getPagoLocalExterior().isConvenioDobleTributacion());
            this.btnNoPagoNormaLegal.setEnabled(esPagoANoResidenteYPeriodoDesdeMarzo2015 && !this.modeloDatos.getPagoLocalExterior().isConvenioDobleTributacion());
            this.habilitarRegimenFiscalPreferenteHastaAbril2016(esPagoANoResidenteYPeriodoDesdeMarzo2015);
        }
    }

    private void habilitarRegimenFiscalPreferenteHastaAbril2016(boolean esPagoANoResidente) {
        this.btnSiPagoRegimenFiscal.setEnabled(esPagoANoResidente && this.periodo.isAnexoEnPeriodoHastaAbril2016());
        this.btnNoPagoRegimenFiscal.setEnabled(esPagoANoResidente && this.periodo.isAnexoEnPeriodoHastaAbril2016());
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue establecimientoModeloDatosObserveValue = BeanProperties.value((String)"establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, establecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue puntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, puntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtSecuencialObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtSecuencial);
        IObservableValue secuencialModeloDatosObserveValue = BeanProperties.value((String)"secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtSecuencialObserveWidget, secuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue numAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, numAutorizacionModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoPago.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoPago.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresTiposPagosObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposPagos");
        this.cvTipoPago.setInput((Object)modeloValoresTiposPagosObserveList);
        ISWTObservableValue btnSiAplicaConvenioObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiAplicaConvenio);
        IObservableValue modeloDatosPagoLocalExteriorconvenioDobleTributacionObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.convenioDobleTributacion");
        bindingContext.bindValue((IObservableValue)btnSiAplicaConvenioObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorconvenioDobleTributacionObserveValue, null, null);
        ISWTObservableValue btnNoAplicaConvenioObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoAplicaConvenio);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoAplicaConvenioObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorconvenioDobleTributacionObserveValue, strategy, strategy_1);
        ISWTObservableValue btnSiPagoNormaLegalObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiPagoNormaLegal);
        IObservableValue modeloDatosPagoLocalExteriorsujetoNormaLegalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.sujetoNormaLegal");
        bindingContext.bindValue((IObservableValue)btnSiPagoNormaLegalObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorsujetoNormaLegalObserveValue, null, null);
        ISWTObservableValue btnNoNormaLegalObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoPagoNormaLegal);
        UpdateValueStrategy strategy_2 = new UpdateValueStrategy();
        strategy_2.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_3 = new UpdateValueStrategy();
        strategy_3.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoNormaLegalObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorsujetoNormaLegalObserveValue, strategy_2, strategy_3);
        ISWTObservableValue btnSiPagoRegimenFiscalObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiPagoRegimenFiscal);
        IObservableValue modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"pagoLocalExterior.pagoRegimenFiscal");
        bindingContext.bindValue((IObservableValue)btnSiPagoRegimenFiscalObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, null, null);
        ISWTObservableValue btnNoPagoRegimenFiscalObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoPagoRegimenFiscal);
        UpdateValueStrategy strategy_4 = new UpdateValueStrategy();
        strategy_4.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_5 = new UpdateValueStrategy();
        strategy_5.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoPagoRegimenFiscalObserveSelectionObserveWidget, modeloDatosPagoLocalExteriorpagoRegimenFiscalObserveValue, strategy_4, strategy_5);
        ISWTObservableValue lblInfoPagoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.lblInfoPago);
        IObservableValue periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDeAnexoDesdeMarzo2015");
        bindingContext.bindValue((IObservableValue)lblInfoPagoObserveEnabledObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue lblPagoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.lblPago);
        bindingContext.bindValue((IObservableValue)lblPagoObserveEnabledObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue cmbPagoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.cmbPago);
        bindingContext.bindValue((IObservableValue)cmbPagoObserveEnabledObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue btnSiPagoNormaLegalObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.btnSiPagoNormaLegal);
        UpdateValueStrategy strategy_6 = new UpdateValueStrategy();
        strategy_6.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnSiPagoNormaLegalObserveEnabledObserveWidget_1, modeloDatosPagoLocalExteriorconvenioDobleTributacionObserveValue, null, strategy_6);
        ISWTObservableValue btnNoNormaLegalObserveEnabledObserveWidget_1 = SWTObservables.observeEnabled((Control)this.btnNoPagoNormaLegal);
        UpdateValueStrategy strategy_7 = new UpdateValueStrategy();
        strategy_7.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoNormaLegalObserveEnabledObserveWidget_1, modeloDatosPagoLocalExteriorconvenioDobleTributacionObserveValue, null, strategy_7);
        ISWTObservableValue lblPagoSujetoRetencionObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblPagoSujetoRetencion);
        IObservableValue periodoAnexoEnPeriodoHastaAbril2016ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"anexoEnPeriodoHastaAbril2016");
        bindingContext.bindValue((IObservableValue)lblPagoSujetoRetencionObserveVisibleObserveWidget, periodoAnexoEnPeriodoHastaAbril2016ObserveValue, null, null);
        ISWTObservableValue btnSiPagoRegimenFiscalObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.btnSiPagoRegimenFiscal);
        bindingContext.bindValue((IObservableValue)btnSiPagoRegimenFiscalObserveVisibleObserveWidget, periodoAnexoEnPeriodoHastaAbril2016ObserveValue, null, null);
        ISWTObservableValue btnNoPagoRegimenFiscalObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.btnNoPagoRegimenFiscal);
        bindingContext.bindValue((IObservableValue)btnNoPagoRegimenFiscalObserveVisibleObserveWidget, periodoAnexoEnPeriodoHastaAbril2016ObserveValue, null, null);
        this.compFiscalidad.initDataBindingsFiscaldiad(bindingContext, (ObjetoModelo)this.modeloDatos);
        return bindingContext;
    }
}

